#!/bin/sh
 
SCRIPT=$(readlink -f $0)
SCRIPT_PATH=$(dirname $SCRIPT)
 
create_deployment_environment() {
    ${ORACLE_COMMON_HOME}/common/bin/wlst.sh -loadProperties ${CUSTOM_PROPERTIES} ${SCRIPT_PATH}/create_deployment_environment.py
}
 
pack_domain() {
    if [ -f ${TEMPORARY_DIRECTORY}/templates/${DOMAIN_NAME}.jar ]; then
        echo 'REMOVING OLD TEMPLATE'
        rm -f ${TEMPORARY_DIRECTORY}/templates/${DOMAIN_NAME}.jar
    fi
    echo 'PACKING DOMAIN'
    ${ORACLE_COMMON_HOME}/common/bin/pack.sh -managed=true -domain=${CONFIGURATION_HOME}/domains/${DOMAIN_NAME} -template=${SCRIPT_PATH}/../_templates/${DOMAIN_NAME}.jar -template_name=${DOMAIN_NAME}
}
 
create_deployment_environment
 
pack_domain
